﻿start();

function start() {    
/**
 **
 **	Willam van Weelden Extendscript library loader
 **
 ** Include this file to load the library
 **
 **
 **/

/* Include dependant files */
function array_key_exists (key, search) {
  // http://kevin.vanzonneveld.net
  // +   original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // +   improved by: Felix Geisendoerfer (http://www.debuggable.com/felix)
  // *     example 1: array_key_exists('kevin', {'kevin': 'van Zonneveld'});
  // *     returns 1: true
  // input sanitation
  if (!search || (search.constructor !== Array && search.constructor !== Object)) {
    return false;
  }

  return key in search;
}
function array_max(array) {
	/*
		Array min - By John Resig
	*/
	return Math.max.apply( Math, array );
}
function array_min(array) {
	/*
		Array min - By John Resig
	*/
    return Math.min.apply( Math, array );
}
function array_toLowerCase(array) {
	var lowercasearray = new Array();
	for(var i = 0; i<array.length; i++) {
	   if(typeof(array[i]) == "string") {
		   lowercasearray.push(array[i].toLowerCase());
		} else {
			lowercasearray.push(array[i]);
		}
	}
	return lowercasearray;
}
function array_remove(array, from, to) {
	/*
		Array Remove - By John Resig (MIT Licensed)
		http://ejohn.org/blog/javascript-array-remove/
	*/
	var rest = array.slice((to || from) + 1 || array.length);
	array.length = from < 0 ? array.length + from : from;
	return array.push.apply(array, rest);
}
function in_array (needle, haystack, strict) {
	
	if(is_array(needle)) {
		alert("in_array expects first parameter to be a string. Array given.");
		return false;
	} else if(!is_array(haystack)) {
		alert("in_array expects second parameter to be an array.")
		return false;
	}
	
	if(!strict) {
		strict = false;
	}
		
	var inarray = false;
	for(var i = 0; i<haystack.length; i++)
	{	
		if(strict)
		{
			if(needle === haystack[i])
			{
				inarray = true;
				break;
			}
		}
		else
		{
			if(needle == haystack[i])
			{
				inarray = true;
				break;
			}
		}
	}
	return inarray;
}
function is_array(object) {
	if(!isValidType(object))
		return false;
	else if(object.constructor.toString().indexOf("Array") == -1)
		return false;
	else
		return true;
}
function ExecuteBatchFile(command, waitforbatch) {
                
	if(string_isEmpty(command))
		return false;

	if(!waitforbatch) {
		if(waitforbatch != false) {
			waitforbatch = true;
		}
	}
	
	var path = Folder.appData.fsName + '/';

	var batFileName = 'ExtendScriptBatchFile';
	var batFileExtension = '.bat';
	var batFile = new File(path+batFileName+batFileExtension);
	if(batFile.exists) {
		var i  = 0;
		while(batFile.exists) {
			i++;
			batFile = new File(path+batFileName+i+batFileExtension);
		}
	}

	command+= "\ndel /F /Q \"" + batFile.fsName + "\"";

	writeFile(batFile, command, false);
	if(!isFile(batFile, true))
		return false;

	batFile.execute();

	/*Wait on batch file execution if needed*/
	if(waitforbatch) {
		while(batFile.exists) {
			msg(".");
			$.sleep(100);
		}
	}
	return true;
}

function openURL(url) {
	ExecuteBatchFile("start "+url+"  \n", false);
}
function getNextMapNumber() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}

	/*Assume that the map numbers are simple incremented numbers*/
	var lowestnumber = 1;
	var highestnumber = 4294967295;

	if(MapNumbers.length == 0) {
		var nextnumber = lowestnumber;
	} else if(!CSHHighestNumberTaken) {/*The hightest number has not yet been taken, or is not know to be taken yet.*/
		var nextnumber = array_max(MapNumbers) + 1;
	} else {
		var nextnumber = highestnumber+1;/*Take the highest number so the search loop will start.*/
	}

	if(nextnumber > highestnumber) {
		CSHHighestNumberTaken = true;/*The highest number has been taken. No need to use the .max() method next time this function is called. Saves time.*/
		if(!CSHNoMoreMapNumbers) {/*By default, there are mapnumbers.*/
			if(CSHLastAssignedNumber == false) {/*Check to see if the function already assigned a MapNumber before. No need to start counting at 1 when there is a higher number.*/
				nextnumber = lowestnumber;
			} else {
				nextnumber = CSHLastAssignedNumber+1;
			}

			/*The highest number has been taken. Determine if there is another number we can use.*/
			while(in_array(nextnumber, MapNumbers)) {
				nextnumber++;
			}

			if(nextnumber > highestnumber) {
				nextnumber = null;
				CSHNoMoreMapNumbers = true;/*There are no more mapnumbers available. No need to loop the set numbers anymore when this function is called again. Saves time.*/
			}
		} else {
			nextnumber = null;
		}
	}
	if(nextnumber == null) {
		alert("There are no more MapId's available in this project.");
	}

	CSHLastAssignedNumber = nextnumber;

	return nextnumber;
}
function unloadCSH() {
	/*
		Reset CSH to false to allow the script to check if the CSH is already initialized.
		Called by unloadcurrentproject();
	*/
	CSH = false;
	MapNumbers = new Array();
	TopicIds = new Array();
}
function loadCSH() {
	/*
		This function loads all the CSH (MapId's, TopicId's and Topic references) into the array CSH.
		Done for easy searching so you don't have to parse all CSH file every time you need this info.
	*/
	
	msg("\nLoading all the project's Context Sensitivity\n");
	
	var aliasfile = "";
	var mapfiles = new Array();
	
	CSH = new Array();
	MapNumbers = new Array();
	TopicIds = new Array();
	
	var CSHtmpArray = new Array();
	
	for(var i = 1; i<=currentProject.FileManager.count; i++) {
		
		var file = currentProject.FileManager.item(i);
		if(file.extension == aliasfileextension) {
			aliasfile = new File(file.path);
		} else if(in_array(file.extension, mapfileextension)) {
			mapfiles.push(new File(file.path));
		}
	}
	
	/* Load all project topicid's and map# */
	for(var i = 0; i<mapfiles.length; i++) {
		var mapfile = mapfiles[i];
		var mapfilecontent = readFile(mapfile).split("\n");
		
		for(var j = 0; j<mapfilecontent.length;j++)
		{
			var line = mapfilecontent[j];
			/*Skip empty lines*/
			if(trim(line) != "") {
				
				/*Both Map# and TopicId are mandatory. So no need to check that both exist*/
				line = line.replace("#define ", "");
				
				/*Separator can be a tab or a space*/
				if(line.match("\t")) {
					line = line.split("\t");
				} else {
					line = line.split(" ");
				}
				
				var thislinearray = new Array();
				/*Load topicid's*/
				thislinearray[CSHTopicidKey] = line[0];
				TopicIds.push(line[0]);
				/*Load map#*/
				thislinearray[CSHMapnumberKey] = parseFloat(line[1]);
				MapNumbers.push(line[1]);
				CSHtmpArray.push(thislinearray);
			}
		}
	}
	
	/*Now get all aliasses and combine the topicid's/Map# with the correct topics*/
	var AliasXML = new XML(readFile(aliasfile));
	var Aliasses = AliasXML.children();
	for(var i = 0; i<Aliasses.length(); i++) {
		var alias = Aliasses[i];
		
		/*The alias file only contains links between topicid and topic. CSH without assigned topic are not in this file.*/
		var topicid = alias.attribute("name").toString();
		var topic = alias.attribute("link").toString().toLowerCase().replace(/\\/g,"/");
		for(var j = 0; j<CSHtmpArray.length; j++) {
			if(CSHtmpArray[j][CSHTopicidKey] == topicid) {
				CSHtmpArray[j][CSHTopicKey] = topic;
				CSH.push(CSHtmpArray[j]);
				array_remove(CSHtmpArray, j);
				break;
			}
			
		}
		
	}
	/*
		Elements still in the array are elements without a topic assigned. These elements need to be pushed to the CSH array too.
	*/
	for(var i = 0; i<CSHtmpArray.length; i++) {
		CSHtmpArray[i][CSHTopicKey] = false;/*No topic available*/
		CSH.push(CSHtmpArray[i]);
	}
	msg("Finished loading Context Sensitivity\n");
}
/*
	For File.convertUTF8, see utf8.jsxinc
	For File.zip(), see zip.jsxinc
*/
function file_content(file, content, encoding) {
	if(!content) {
	   content = false;
	}

	if(!encoding || encoding == true) {
	   encoding = "UTF-8";
	}
			   
	if(!content) {
	   return readFile(file, encoding);
	} else {
	   writeFile(file, content, encoding);
	   return true;
	}
}
function readFile(file, encoding) {
	var thisfile = file;
	var szFilePath = thisfile.fsName;
	
	if(!isFile(thisfile)) {
	   return null;
	}
	
	if(!encoding || encoding == true) {
	   encoding == "UTF-8";
	}

	var szRetVal = "";
	var fileObj = new File(szFilePath);
	fileObj.encoding = encoding;
	fileObj.open("r");
	while (!fileObj.eof) {
	   szRetVal += fileObj.readln()+"\n";
	}
	fileObj.close();
	return szRetVal;
}
function writeFile(file, szOutput, encoding) {
	var szFilePath = file.fsName;
	
	if(!encoding || encoding == true) {
	   encoding = "UTF-8";
	}
	
	var fileObj = new File(szFilePath);
	fileObj.encoding = encoding;
	fileObj.open("w");
	fileObj.write(szOutput);
	fileObj.close();
}
function extension(filename) {
	var ext = "";/*If no extension, return an empty string.*/
	var index = filename.lastIndexOf(".");
	if(index != -1) {
		ext = filename.substr(index, filename.length - index).toLowerCase();
	}
	return ext;
}
function filename(absolutepath) {/*Returns filename from absolute path.*/
	absolutepath = absolutepath.replace(/\\/g, "/");
	return absolutepath.substring(absolutepath.lastIndexOf("/")+1);
}
function FilePathExists(absolutepath) {
	var file = new File(absolutepath);
	return isFile(file, true);
}
function folder(absolutepath) {/*Returns path from absolute path to file*/
	absolutepath = absolutepath.replace(/\\/g,"/");
	return absolutepath.substring(0,absolutepath.lastIndexOf("/"));
}
function isValidFilePath(path, filename) {
	if(!isValidType(path)) {
        return false;
	} else if(is_array(path)) {
		return false;
	}
    
    var bRetVal = !string_isEmpty(path) && FilePathExists(path);
    if (bRetVal) {
        bRetVal = false;
        path = path.toLowerCase();
        if (path.length > filename.length) {
            path = path.substr(path.length - filename.length);
            if (path == filename) {
                bRetVal = true;
            }
        }
    }
    return bRetVal;
}
function isFile(file, mustexist) {/*Check whether an object is a file object and optionally whether the file exists on the file system.*/
	if(!mustexist) {
		mustexist = false;
	}
	
	var isfile = false;
	if(file instanceof File)
	{
		isfile = true;
		
		if(mustexist) {
			if(!file.exists) {
				isfile = false;
			}
		}
	}
	return isfile;
}
/*
	For Folder.zip(), see zip.jsxinc
*/
function copyFolder (srcFolder, tarFolder) {
	var listOfFiles = new Array();
	if(!isFolder(srcFolder, true)) {
		return null;
	}
	if(!isFolder(tarFolder, true)) {
		tarFolder.create();
	}
	
    listOfFiles = srcFolder.getFiles("*.*");
    for (; listOfFiles.length > 0; ) {
        tFile = listOfFiles.pop();
        if (tFile instanceof Folder) {
            var tempFolder = Folder(tarFolder.fsName.concat("\\", tFile.displayName));
            
			if (!isFolder(tempFolder, true)) {
				tempFolder.create()
			}
            
			tFile.copy(tempFolder);
        }
        else {
            tFile.copy(tarFolder.fsName.concat("\\", tFile.displayName));
        }
    }
}
function getFilesRecursive(folder) {
	var editfiles = new Array();
	var files = folder.getFiles("*.*");
	for(var i = 0; i<files.length; i++)
	{
		var tempfile = files[i];
		if (isFolder(tempfile)) {/* Load folder recursive */
			var tmpfolder = new Folder(tempfile);
			var temparray = getFilesRecursive(tmpfolder);
			editfiles = editfiles.concat(temparray);
		}
		else if(isFile(tempfile)) {
			 editfiles.push(tempfile);
		}
	}
	return editfiles;
}
function removeFolder(folder) {
	
	var string = 'rd "'+folder.fsName+'" /s /q';
	ExecuteBatchFile(string);
	
}
function isFolder(folder, mustexist) {/*This is a function and not a prototype because this function must be available for all data types*/
	if(!mustexist) {
		mustexist = false;
	}
	
	var isfolder = false;
	if(folder instanceof Folder)
	{
		isfolder = true;
		
		if(mustexist) {
			if(!folder.exists) {
				isfolder = false;
			}
		}
	}
	return isfolder
}
function isLinkedFile(file, type) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	/*This function works for the FileManager and the TopicManager.*/
    var alltypes = "all";
    if(!type) {
        type = alltypes;
	}
 
	if(currentProject == null)
    {
        alert("Please load the project info using the function loadcurrentproject().");
        return null;
    }

	var allowedparents = new Array("[object TopicManager]", "[object FileManager]");
	if(!in_array(file.parent, allowedparents))
	{
		alert("The isLinked method can only be used on topics from the TopicManager and files from the FileManager.");
		return null;
	}
	
	if(!file.valid) {/*Check to see if topic/file exists*/
        return false;
	}
	
	if(!is_array(LinkedFMDocs) || !is_array(LinkedWordDocs)) {
		loadLinkedFiles();
	}
    
	var FileRelPath = file.path.substring(projectpath().length).replace(/\//g, "\\");
		
	var LinkedFiles = new Array();
    var linked = false;
 
    if(type.toLowerCase() == "framemaker" || type == alltypes) {/*Check FM*/
        LinkedFiles = LinkedFiles.concat(LinkedFMDocs);
	}
    if(type.toLowerCase() == "word" || type == alltypes) {/*Check Word*/
        LinkedFiles = LinkedFiles.concat(LinkedWordDocs);
	}
 
	if(in_array(FileRelPath.toLowerCase(), LinkedFiles.toLowerCase())) {
		linked = true;
	}
		
    return linked;
}
function unloadLinkedFiles() {
	LinkedFMDocs = false;
	LinkedWordDocs = false;
}
function loadLinkedFiles() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	var Xpath = "//genfile/filename";
	var loadFilesThatAreLinked = function(filepath) {
		var LinkedFiles = new Array();
        var ContainerFile = new File(filepath);
        if(ContainerFile.exists)
        {
			var ContainerXML = new XML(readFile(ContainerFile));
			var LinkedFilesinContainer = ContainerXML.xpath(Xpath).children();
			for(var i = 0; i< LinkedFilesinContainer.length();i++)
			{
				LinkedFiles.push(LinkedFilesinContainer[i].toString());
			}
			return LinkedFiles;
        } else {
			return null;
		}
    }
	/*Load FrameMaker*/
	LinkedFMDocs = loadFilesThatAreLinked(projectpath()+FMContainer);
	/*Load Word*/
	LinkedWordDocs = loadFilesThatAreLinked(projectpath()+WordContainer);
}
function setLogFile(fullpath) {
	var tempfile = new File(fullpath);
	if(isFile(tempfile)) {
		logfile = tempfile;
	}
}
function log(logmessage) {

	/* Create timestamp for use in log file */
	var date = new Date();
	var year = date.getFullYear().toString();
	var month = date.getMonth().toString();
    var day = date.getDay().toString();
	var time = date.getHours().toString() + ':' + date.getMinutes().toString() + ':' + date.getSeconds().toString();
	var timestamp = year+'-'+month+'-'+day+' '+time;

    /*Initialize the log file only once.*/
    if(logfile == false) {
		var logfilename = "RoboHelp_ExtendScript_Log.log";
		var folder = $.fileName;/* When log file is not specified (with setLogFile) save the log file in the same folder as the script. */
		folder = folder.replace(/\\/g,"/");
		folder = folder.substring(0,folder.lastIndexOf("/")+1);
		logfile = new File(folder+logfilename);
	}
	
	/* Open the log file. Create if it does not exist. */
	if(isFile(logfile, true)) {
		logfile.open("a");
	} else {
		logfile.open("w+");
	}
    
	/* Write log file contents */	
	logfile.write(timestamp+"\t"+logmessage+"\n");
	logfile.close();     

}
function isValidType(value) {
    if (typeof (value) !== 'undefined' && value != null) {
        return true;
    }
    return false;
}

function confirm(message, noAsDflt, title) {
	/* Shorthand for Window.confirm because RoboHelp doesn't support the shorthand. */
	if(!message) {
		return null;
	}
	if(!noAsDflt) {
		noAsDflt = false;
	}
	if(!title) {
		title = false;
	}
	
	if(title == false) {
		return Window.confirm(message, noAsDflt);
	} else {
		return Window.confirm(message, noAsDflt, title);
	}
}

function prompt(message, preset, title) {
	/* Shorthand for Window.prompt because RoboHelp doesn't support the shorthand. */
	if(!message) {
		return null;
	}
	if(!preset) {
		preset = "";
	}
	if(!title) {
		title = false;
	}
	
	if(title == false) {
		return Window.prompt(message, preset);
	} else {
		return Window.prompt(message, preset, title);
	}
}
function uniqueid() {/*Return a unique id*/
	
	var result, i, j;
	result = '';
	for(j=0; j<32; j++)
	{
		if( j == 8 || j == 12|| j == 16|| j == 20) {
		result = result + '-';
		}
		i = Math.floor(Math.random()*16).toString(16).toUpperCase();
		result = result + i;
	}
	return 'uid-'+result
	
}
function clearmsg() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(IsRoboHelp9OrLater() && currentProject != null) {
		RoboHelp.project.clearOutputViewLog();
	}
}
function closeproject() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(currentProject == null)
	{
		loadcurrentproject(false);
		if(currentProject == null)
		{
			alert("Cannot close the current project as there is no project opened.");
			return null;
		}
	}
	
	var tmpproject = currentProject;
	unloadcurrentproject();
	RoboHelp.closeProject();
	return true;
}
function loadcurrentproject(showerror) {/*If project is loaded after the library is initialized, this function must be run to initialize the variable currentProject*/
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(!showerror) {
		if(showerror != false) {
			showerror = true;
		}
	}
	
	if(projectavailable()) {
		currentProject = RoboHelp.getCurrentProject();
	} else if(showerror) {
		alert("There is no RoboHelp project to load. Try loading the project and calling the function getcurrentproject() again.");
	}
}
function msg(message) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(currentProject != null) {
		RoboHelp.project.outputMessage(message);
	}
}
function openproject(xpjpath, updateifrequired) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(!updateifrequired) {
		updateifrequired = false;
	}
	
	if(!isValidType(xpjpath) || !isValidFilePath(xpjpath, xpjextension)) {
		return false;
	}
	
	var prj = new File(xpjpath);
	if(folder(prj.fsName)+"/" == projectpath())
	{
		alert("This project is already open.");
		return false;
	}
	else
	{
		unloadcurrentproject();/*Unload current project from variable currentProject.*/
		RoboHelp.openProject(prj.fsName, updateifrequired);/*Open project*/
		loadcurrentproject(false);/*Load opened project into variable currentProject.*/
		return true;
	}
	
}
function openprojectdialog(updateifrequired) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(!updateifrequired) {
		updateifrequired = false;
	}
	
	var prj = new File();
	prj = prj.openDlg("Choose project to open", "Project file:*.xpj", false);
	if(!isValidType(prj) || !isValidFilePath(prj.fsName, xpjextension)) {
		return false;
	}
	
	return openproject(prj.fsName, updateifrequired);

}
function unloadcurrentproject() {
	unloadCSH();
	unloadLinkedFiles();
	currentProject = null;
}
function projectavailable() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(isValidType(RoboHelp.getCurrentProject()))
		return true;
	else
		return false;
}

function projectpath() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(currentProject != null) {
		return currentProject.path.replace(/\\/g, "/")+"/";
	} else {
		return null;
	}
}
function projecttitle() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	if(currentProject != null) {
		return currentProject.title;
	} else {
		return null;
	}
}
function projectlanguage() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(currentProject == null) {
		return null
	} else {
		var projectlang = "en";
		if (IsRoboHelp9OrLater()) {
			try {
				projectlang = RoboHelp.Language.getNameFromID(currentProject.language);
			} catch (e) {
				/*Silently swallow exceptions*/
			}
		}
		return projectlang;
	}
}
function IsRoboHelp9OrLater() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
    var versionString = RoboHelp.version;
    var iVersion = parseInt(versionString);
    return (iVersion >= 9);
}
function IsRoboHelp10OrLater() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
    var versionString = RoboHelp.version;
    var iVersion = parseInt(versionString);
    return (iVersion >= 10);
}
function IsRoboHelp11OrLater() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
    var versionString = RoboHelp.version;
    var iVersion = parseInt(versionString);
    return (iVersion >= 11);
}
function IsRoboHelp2015OrLater() {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
    var versionString = RoboHelp.version;
    var iVersion = parseInt(versionString);
    return (iVersion >= 12);
}
function saveSetting(setting, rawValue, scope) {
    if(!scope) {
        scope = "project";
    }
	
	/* Make tagname safe */
	setting = safeTagName(setting);
	
	if(RHInit == false) {/* When RoboHelp is not opened, the scope is always global */
		scope = "global"
	}
	
    if(currentProject == null && scope != "global") {
		return false;
	}

	var settings = allSettings(scope);
	if(settings == false || string_isEmpty(settings.toString())) {/*No file yet or empty*/
		settings = new XML("<scriptsettings/>");
	}
	
	/* Setting with multple values (array) */
	if(is_array(rawValue)) {
		var xmlString = new XML("<"+setting+"/>");
		for(var i=0; i<rawValue.length;i++){
			xmlString.appendChild(new XML("<value><![CDATA["+htmlspecialchars(rawValue[i])+"]]></value>"));
		}
	} else {
		var xmlString = new XML("<"+setting+"><![CDATA["+htmlspecialchars(rawValue)+"]]></"+setting+">");
	}
	
	/*Is this setting already availble?*/
	if(!string_isEmpty(trim(settings.child(setting).toString()))) {
		settings.replace(setting, xmlString);/*Replace existing value*/
	} else {
		settings.appendChild(xmlString);/*Add new value*/
	}
	
	var settingsFileResource = getSettingsFile(scope);
    writeFile(settingsFileResource, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+settings.toXMLString());
	return true;
}
function loadSetting(setting, scope) {
	
	/* Make tagname safe */
	setting = safeTagName(setting);

	if(!scope) { scope = "project"; }
	
	if(RHInit == false) {/* When RoboHelp is not openend, the scope is always global */
		scode = "global";
	}
    
    if(currentProject == null && scope != "global") {
		return null;
	}
	var settings = allSettings(scope);
	if(settings == false || string_isEmpty(settings.toString())) {
		return null;
	} else {
		var xmlSetting = settings.child(setting);
		if(xmlSetting.xpath('value').length() > 0) {/* Children, so multiple values */
			var xmlSettings = xmlSetting.children();
			var returnArray = new Array();
			for(var i=0; i<xmlSettings.length(); i++) {
				returnArray.push(xmlSettings[i].toString());
			}
			return returnArray;
		} else {/* Only a single value */
			return xmlSetting.toString();
		}
	}
}
function allSettings(scope) {
    var settingsFileResource = getSettingsFile(scope);
	if(isFile(settingsFileResource), true)/*Does the settings file already exist?*/
		return new XML(readFile(settingsFileResource));
	else
		return false;
}
function getSettingsFile(scope) {
    /*Settings file name*/
    var settingsFile = "scriptSettingFile.xml";
    
    if(scope == "global") {
        var settingsFile = new File(Folder.appData.fsName + '/'+ settingsFile);
    } else if (currentProject != null){
        var settingsFile = new File (projectpath()+settingsFile);
    } else {
        var settingsFile = null;
    }
    return settingsFile;
}
function ssl_outputDir(SSL) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(SSL.parent != "[object SSLManager]") {
	   alert("You can only use the method/function outputDir() on SSL objects");
	   return null;
	}
	
	if(SSL.layoutType == RoboHelp.SSLLayoutType.MULTISCREENHTML5) {
		return folder(SSL.getSpecificProperty("DestinationProjectName")) + '/';
	} else {
		return folder(SSL.outputFileName)+"/";
	}
	
}
function string_count(string, s1) {
	if(typeof(string) != "string") {
		return null;
	}
	return (string.length - string.replace(new RegExp(s1,"g"), '').length) / s1.length;
}
function string_isEmpty(string) {
	if(typeof(string) != "string") {
		return null;
	}
	var isempty = true;
	if(isValidType(string))
	{
		if(trim(string).length > 0) {
			isempty = false;
		}
	}
	return isempty;
}
function string_toBoolean(string) {
	if(typeof(string) != "string") {
		return null;
	}
	var truearray = new Array("true", "1");
	var falsearray = new Array("false", "0", "-1");
	if(in_array(string, truearray)) {
		return true;
	} else if(in_array(string, falsearray)) {
		return false;
	} else {
		return null;
	}
}
function trim(string) {
	if(typeof(string) != "string") {
		return null;
	}
	return string.replace(/^\s+|\s+$/g, "");
}
function token_balancedDelete(Token, contentdelete) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
 
    if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the balancedDelete function on tokens from the TokenManager.");
        return null;
    }
 
    var SingleDelete = function(token) {
        var Single = false;
 
        if(token.tokenType == RoboHelp.TokenType.TOKENTEXT)
        {
            Single = true;
        }
        else if(token.tokenType == RoboHelp.TokenType.TOKENTAG)
        {
            if(token.name.match(/(<\/)/g) || token.name.match(/(\/>)/g))/* End tags or shorthand tags */
                Single = true;
            else
            {   
				/* If no match of yet, make sure that the tag is not a known html shorthand tag. HTML 4.01 allows shorthand tags like <br> */
				var ShortTags = new Array("area","base","basefont","br","col","frame","img","input","link","meta","param");
				if(token_isTag(token, ShortTags))
					Single = true;
			}
        }
        return Single;
    }
 
    if(SingleDelete(Token))
    {
		Token.delete();
	}
    else
    {
            var TokenDelete = new Array(Token);
            var tag = cleantag(Token.name);
            var endTag = "/"+tag;
            var i = 0;
            var RetreivedAll = false;
            var sToken = Token.next;
            while(RetreivedAll == false)
            {
                if(token_isTag(sToken, tag))
                {
                    i++;
                    if(contentdelete)
                        TokenDelete.push(sToken);
                }
                else if(token_isTag(sToken, endTag) && i != 0)
                {
                    i--;
                    if(contentdelete)
                        TokenDelete.push(sToken);
                }
                else if(token_isTag(sToken, endTag) && i == 0)
                {
                    TokenDelete.push(sToken);
                    RetreivedAll = true;
                }
                else if(contentdelete)
                    TokenDelete.push(sToken);
 
                sToken = sToken.next;
            }
 
            for(var j = 0;j<TokenDelete.length;j++)
            {
                TokenDelete[j].delete();
            }
     }
    return true;
}
function token_hasAttribute(Token, attribute, empty) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
 
     if(!empty)
        empty = false;
	
	if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the hasAttribute functions on tokens from the TokenManager.");
        return null;
    }
    else if(!attribute)
    {
        alert("No attribute specified");
        return null;
    }
 
    if(Token.tokenType != RoboHelp.TokenType.TOKENTAG)/* It's not a tag at all */
        return false;
 
    var hasAttribute = false;
 
    if(Token.getAttribute(attribute) != "")
        hasAttribute = true;
    else if(empty)/* Search for empty attribute */
    {
        var attrstring = attribute+'=("|\')';/* Append =" or =' to attribute name. */
        var attr = new RegExp(attrstring);
        if(Token.name.match(attr))
            hasAttribute=true;
    }
 
    return hasAttribute;
}
function token_isTag(Token, Tag, casesensitive) {
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(!casesensitive)
		casesensitive = false;

	if(Token.parent != "[object TokenManager]")
	{
		alert("You can only use the isTag functions on tokens from the TokenManager.");
		return null;
	}
 
    if(Token.tokenType == RoboHelp.TokenType.TOKENTEXT)/* It's not a tag at all. Allow both tags and XMI-tags to be validated. */
        return false;
 
    if(!Tag)/* No tag specified and this is a tag so return true */
        return true;
 
    var isTag = false;
    var fullTag = Token.name;
    var TagName = cleantag(fullTag);/* Get the tag name without brackets */
 
    if(!is_array(Tag))
    {
        var TagArray = new Array;
        TagArray[0] = Tag;
    } else {
        var TagArray = Tag;
    }
	
	if(!casesensitive)
	{
		/* Matching is not case sensitive. Put everything in lower case */
		TagName = TagName.toLowerCase();
		TagArray = array_toLowerCase(TagArray);
	}
 
	if(in_array(TagName, TagArray))
		isTag = true;

    return isTag;
}
function token_getText(token, includeHTML) {
	var done = false, text = '', tokenName = cleantag(token.name);
	
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(token.parent != "[object TokenManager]")/* Only allow tokens from the TokenManager */
    {
        alert("You can only use the getText functions on tokens from the TokenManager.");
        return null;
    }
	
	if(!includeHTML) {
		includeHTML = false;
	}
	
	var matchToken = token.next;
	var i = 0;
	while(done === false) {
		
		if(matchToken.tokenType == RoboHelp.TokenType.TOKENTEXT)//Text content. Add to match text.
		{
			text += matchToken.name;
		}
		else if(matchToken.isTag(tokenName))
		{
			i++;
			if(includeHTML === true) {
				text += matchToken.name;
			}
		}
		else if(matchToken.isTag("/"+tokenName) && i>0)
		{
			i--;
			if(includeHTML === true) {
				text += matchToken.name;
			}
		}
		else if(matchToken.isTag("/"+tokenName) && i==0)
		{
			done = true;
		}
		else if(includeHTML === true)
		{
			text += matchToken.name;
		}
		matchToken = matchToken.next;
	}
	
	//Remove unneeded characters
	text = text.replace(/(\n)/g, "");
	text = text.replace(/(\t)/g, "");
	text = text.replace(/\s{2,}/g, " ");
	text = text.replace(/(&#160;)/g, " ");//Also remove non breakable spaces for in most cases we simply want to know that a space exists.
	
	return text;
}
function token_getEndToken(token) {
	var done = false, endToken, tokenName = cleantag(token.name);
	
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	if(token.parent != "[object TokenManager]")/* Only allow tokens from the TokenManager */
    {
        alert("You can only use the getText functions on tokens from the TokenManager.");
        return null;
    }
	
	var sToken = token.next;
	var endTag = "/"+tokenName;
	var i = 0;
	while(done == false) {
		
		if(token_isTag(sToken, tokenName))
		{
			i++;
		}
		else if(token_isTag(sToken, endTag) && i != 0)
		{
			i--;
		}
		else if(token_isTag(sToken, endTag) && i == 0)
		{
			endToken = sToken;
			done = true;
		}
		
		sToken = sToken.next;
	}
	
	return endToken;
}
function  cleantag (tag) {
	if(tag.match(" ")) {
		tag = tag.split(" ")[0];/* Remove attributes the lazy way. All attributes are separated by spaces from the tag name. */
	}
	
	tag = tag.replace(/[<>]/g, "");
	
    if(tag.substr(-1) == "/") {
		tag = tag.substr(0,tag.length-1);
	}
	
	return tag;
}
function topicCSH(topic, topicid, mapnumber) { 
	if(RHInit == false) {/* RoboHelp must be available before this can be called. */
		return null;
	}
	
	/*Object to get the CSH of a topic.*/
	if(topic.parent != "[object TopicManager]") {
		alert("The CSH method can only be used on topics from the TopicManager");
		return null;
	}
	
	/*Project CSH settings are not initialized yet.*/
	if(CSH == false)
		loadCSH();
	
	var topicrelpath = topic.path.toLowerCase().replace(/\\/g, "/").replace(projectpath().toLowerCase(), "");
	
	if(!topicid) {
		topicid = false;
		mapnumber = false;
	}
	
	/*Get the CSH for the topic and return that.*/
	if(topicid === false) {
		var topicCSH = new Array();
		
		for(var i = 0; i<CSH.length; i++) {
			if(CSH[i][CSHTopicKey] != false) {
				if(CSH[i][CSHTopicKey].toLowerCase() == topicrelpath) {
					var tmpArray = [];
					tmpArray[CSHTopicidKey] = CSH[i][CSHTopicidKey];
					tmpArray[CSHMapnumberKey] = CSH[i][CSHMapnumberKey];
					
					topicCSH.push(tmpArray);
				}
			}
		}
		
		if(topicCSH.length >= 1)
			return topicCSH;
		else
			return false;
			
	} else {/*Set CSH for the topic.*/
		
		msg("\nSetting CSH for topic \""+topicrelpath+"\"\n");
		
		var returnvalue = true;
		
		if(!in_array(topicid, TopicIds) && !in_array(mapnumber, MapNumbers)) {
			
			currentProject.MapIdManager.newMapId(topicid, mapnumber);
			currentProject.MapIdManager.assign(topicid, topicrelpath);
			
			/*Add new mapnumbers to the correct arrays*/
			var tmpArray = new Array();
			tmpArray[CSHTopicidKey] = topicid;
			tmpArray[CSHMapnumberKey] = mapnumber;
			tmpArray[CSHTopicKey] = topicrelpath;
			CSH.push(tmpArray);
			
			MapNumbers.push(mapnumber);
			TopicIds.push(topicid);
		} else if (in_array(topicid, TopicIds) && in_array(mapnumber, MapNumbers)) {
			/*Assume that given id's are assigned correctly.*/
			currentProject.MapIdManager.assign(topicid, topicrelpath);
			/*Assign the topic to the id's in the CSH array.*/
			for(var i = 0; i<CSH.length; i++) {
				if(CSH[CSHTopicidKey] == topicid) {
					CSH[CSHTopicKey] = topicrelpath;
					break;
				}
			}
		} else {
			/*There is something wrong*/
			returnvalue = false;
			alert("Error while assigning CSH. Map# and TopicId must both exist or must both be absent from project.");
		}
		
		return returnvalue;
		
	}
}
/* Support functions for File.convertUTF8()*/
function convertUTF8(file, fileencoding) {
	if(!isFile(file, true)) {
		return false;
	}
	if(!fileencoding) {/*Default file encodings*/
		fileencoding = 'iso-8859-1';
	}
   
	content = readFile(file, fileencoding);
	writeFile(file, content);
	return true;
}
function htmlspecialchars(string) {
	if(!string.isEmpty()) {
	   string = string.replace(/&/g,"&amp;");
	   string = string.replace(/</g,"&lt;");
	   string = string.replace(/>/g,"&gt;");
	   string = string.replace(/"/g,"&#039;");
	   string = string.replace(/'/,"&apos;");
	}
	return string;
}
function safeTagName(string) {
	string = string.replace(/[^a-zA-Z0-9_]/g, "_");
	if(string.substring(0,1).match(/[^a-zA-Z]/g, "_")) {
		string = "safe_"+string;
	}
	return string;
}
function zipFile(file, zipname, method, compression, archivecommand) {/* Zip a single file */	
	if(!isFile(file, true))
	{
		alert("File "+file.fsName+" does not exist. Cannot zip file.");
		return false;
	}
	else if(!ZipLocation())/*No location. Cannot zip file*/
	{
		return false;
	} 
	else if(string_isEmpty(zipname))
	{
		alert("No name for archive specified. Cannot zip file "+file.fsName);
		return false;
	}

	if(!method) {
		method = "tzip";
	}
	if(!compression) {
		compression = false;
	}
	if(!archivecommand) {
		archivecommand = "a";
	}
		
	var batchtxt = "";
		
	if(validZipMethod(method) && validZipCompression(compression) && validArchiveCommand(archivecommand))
	{
		batchtxt+='"'+v7Location+'" '+archivecommand+' -'+method+' "'+zipname+'" '+'"'+file.fsName+'"';
		if(compression != false)
			batchtxt+=' -mx'+compression;
		
		return ExecuteBatchFile(batchtxt);
	}
	else
	{
		alert("Invalid options for archive specified. Cannot zip file "+file.fsName);
		return false;
	}
}
function zipFolder(folder, zipname, method, compression, archivecommand) {/* zip a folder. This is always recursive */
	if(!isFolder(folder, true))
	{
		alert("Folder "+folder.fsName+" does not exist. Cannot zip folder.");
		return false;
	}
	else if(!ZipLocation())/*No location. Cannot zip file*/
	{
		return false;
	}
	else if(string_isEmpty(zipname))
	{
		alert("No name for archive specified. Cannot zip file "+file.fsName);
		return false;
	}

	if(!method) {
		method = "tzip";
	}
	if(!compression) {
		compression = false;
	}
	if(!archivecommand) {
		archivecommand = "a";
	}
	
	var batchtxt = "";
	
	if(validZipMethod(method) && validZipCompression(compression) && validArchiveCommand(archivecommand))
	{
		batchtxt+='"'+v7Location+'" '+archivecommand+' -'+method+' "'+zipname+'" '+'"'+folder.fsName+"\\*"+'"';
		if(compression != false)
			batchtxt+=' -mx'+compression;
			
		return ExecuteBatchFile(batchtxt);
	}
	else
	{
		alert("Invalid options for archive specified. Cannot zip folder "+folder.fsName);
		return false;
	}
}
/* Support functions for File.zip() and Folder.zip() */
function isValid7ZipPath () {
	if(!isValidFilePath(v7Location, "7z.exe")  && !isValidFilePath(v7Location, "7za.exe")) {
		return false;
	} else {
		return true;
	}
}
function validArchiveCommand(archivecommand) {
	var v7commands = new Array("a", "u");/*Add to archive (or create new) / update file in archive */
	if(in_array(archivecommand, v7commands)) {
		return true;
	} else {
		return false;
	}
}
function validZipCompression(compression) {
	var v7compression = new Array("0", "1", "3", "5", "7", "9", false);/*Compression goes: none, very low, fast, normal, high, ultra, use 7zip default.*/
	if(in_array(compression, v7compression)) {
		return true;
	} else {
		return false;
	}
}
function validZipMethod(method) {
	var v7methods = new Array("t7z", "tgzip", "tzip", "tbzip2", "tiso", "tudf");/*Supported archive types.*/
	if(in_array(method, v7methods)) {
		return true;
	} else {
		return false;
	}
}
function ZipLocation() {/*Add location of 7-Zip executable to v7Location. (Script duration only.) Return true on succes, false on fail.*/
	if(!isValid7ZipPath())
	{
		var ziploc = new File();
		ziploc = ziploc.openDlg("Please choose 7-Zip executable to zip the file","7-Zip executable: 7z.exe;7za.exe");
		if(isFile(ziploc, false)) {
			v7Location = ziploc.fsName;
		}
			
		if(!isValid7ZipPath())
		{
			alert("The path to 7-Zip is not valid.");
			return false;
		}
	}
	return true;
}
	
/* Function used to initialize the library */
function libInit() {
	RHInit = false;
	libVersion = 20160812;
	currentProject = null;	
	
	if(typeof(v7Location) == "undefined") {/* Initialize global vars. */
		/*
		 *
		 * All global variables and methods are set initialized in this function because RH10 events dont instantiate global variables.
		 * This is bad practice. If you have a better solution, please let me know (http://www.wvanweelden.eu/contact).
		 *
		 */
		 
		v7Location = 'C:/Program Files/7-Zip/7z.exe';
		xpjextension = ".xpj";
		
		/*Container files*/
		FMContainer = "RHFrameDocs.apj";
		WordContainer = "RHWordDocs.apj";
		aliasfileextension = ".ali";
		mapfileextension = new Array(".h", ".hh", ".hm");

		/*Linked file information variables*/
		LinkedFMDocs = false;
		LinkedWordDocs = false;
		/*CSH information variables*/
		CSH = false;
		MapNumbers = new Array();
		TopicIds = new Array();
		CSHTopicidKey = "topicid";
		CSHMapnumberKey = "mapnumber";
		CSHTopicKey = "topic";
		CSHHighestNumberTaken = false;
		CSHNoMoreMapNumbers = false;
		CSHLastAssignedNumber = false;
		/*Log file*/
		logfile = false;
		
	}
	
	/* Initialize prototype functions (shorthands) */
/* Array */
Array.prototype.max = function() {
	return array_max(this);
};
Array.prototype.min = function(){
	return array_min(this);
};
Array.prototype.remove = function(from, to) {
	return array_remove(this, from, to);
}
Array.prototype.toLowerCase = function() {
	return array_toLowerCase(this);
}
/* File */
File.prototype.convertUTF8 = function (fileencoding) {
	return convertUTF8(this, fileencoding);
}
File.prototype.content = function(content, encoding) {
	return file_content(this, content, encoding);
}
File.prototype.extension = function() {
    return extension(this.fsName);
}
File.prototype.folder = function() {
    return folder(this.fsName);
}
File.prototype.readFile = function (encoding) {
	return readFile(this, encoding);
}
File.prototype.writeFile = function (szOutput, encoding) {
	return writeFile(this, szOutput, encoding);
}
File.prototype.zip = function (zipname, method, compression, archivecommand) {/* Zip a single file */
	return zipFile(this, zipname, method, compression, archivecommand);
}
/* Folder */
Folder.prototype.zip = function (zipname, method, compression, archivecommand) {/* zip a folder. This is always recursive */
	return zipFolder(this, zipname, method, compression, archivecommand);
}
Folder.prototype.copy = function(tarFolder) {
    copyFolder(this, tarFolder);
}
Folder.prototype.getFilesRecursive = function() {
	return getFilesRecursive(this);
}
/* Linked files */
Object.prototype.isLinked = function(type) {
	return isLinkedFile(this, type);
}
/* Strings */
String.prototype.count = function (s1) {   
	return string_count(this.toString(), s1);
}
String.prototype.isEmpty = function () {
	return string_isEmpty(this.toString());
}
String.prototype.toBoolean = function() {
	return string_toBoolean(this.toString());
}
String.prototype.trim = function() {
	return trim(this.toString());
}
/* SSL */
Object.prototype.outputDir = function() {
	return ssl_outputDir(this);
}
/* Tokens */
Object.prototype.balancedDelete = function (contentdelete) {
	return token_balancedDelete(this, contentdelete);
}
Object.prototype.hasAttribute = function(attribute, empty) {
	return token_hasAttribute(this, attribute, empty);
}
Object.prototype.isTag = function(Tag, casesensitive) {
	return token_isTag(this, Tag, casesensitive);
}
Object.prototype.getText = function(includeHTML) {
	return token_getText(this, includeHTML);
}
Object.prototype.getEndToken = function() {
	return token_getEndToken(this);
}
/* Topic */
Object.prototype.CSH = function(topicid, mapnumber) {
	return topicCSH(this, topicid, mapnumber);
}
	
	/* Is RoboHelp available? */
	if(typeof(RoboHelp) != "undefined") {
		RHInit = true;
		loadcurrentproject(false);/*Load the current project into the variable currentProject.*/
	}
}
libInit();/* Auto init library */
    var topics = currentProject.TopicManager;
    for(var i = 1; i<= topics.count; i++) {
        optimizeTopic(topics.item(i).path, 'topic');
    }
}

/* Optimizes topic for search engines by adding meta title and meta description tags.
- Meta title is generated by reading the page title (<title>).
- Meta description is generated by reading contents of a tag + class of your choice (e.g. <p class="teaser">) */
function optimizeTopic(filepath, type) {
    var tokens = RoboHelp.getTokenManager(filepath);
    var saveme = false;
    var headToken;    
    var metaTitleToken;
    var metaDescriptionToken;
    var descriptionToken;
    var titleToken;
    var descriptionText;
    var titleText;    
    // EDIT: Specify where meta description information should be read from. By default, information is read from <p class="teaser">...</p> (first occurence on page).
    var descriptionTag = "p";
    var descriptionClass = "teaser";
    // EDIT: Maximum number of characters for meta title and description. Recommended for Google: 55 / 155.
    var maxTitleLength = "55";
    var maxDescriptionLength = "155";

    if(typeof(tokens) != "undefined")
	{
        // Check that the file is not empty
        if(tokens.count>0)
        {
            // Get first token
            var token = tokens.item(1);
            // Loop through all the tokens and save specific tokens for later use
            while(typeof(token)!="undefined")
            {
                // Get current meta title
                if(token.isTag("meta") && token.getAttribute("name").indexOf("title") != -1) {
                    metaTitleToken = token;
                }
                // Get current meta description
                if(token.isTag("meta") && token.getAttribute("name").indexOf("description") != -1) {
                    metaDescriptionToken = token;
                }
                // Get meta description from first occurence of descriptionTag with descriptionClass
                if(typeof(descriptionToken)=="undefined" && token.isTag(descriptionTag) && token.getAttribute("class").indexOf(descriptionClass) != -1) {
                    descriptionToken = token;
                    descriptionText = descriptionToken.getText(false).trim();                
                    if (descriptionText.length > maxDescriptionLength) {
                        descriptionText = descriptionText.substr(0, maxDescriptionLength - 3) + "...";
                    }
                }
                // Get page title
                if(token.isTag("title")) {
                    titleToken = token;
                    titleText = titleToken.getText(false).trim();
                    if (titleText.length > maxTitleLength) {
                        titleText = titleText.substr(0, maxTitleLength - 3) + "...";
                    }
                }
                // Get <head> tag
                if (token.isTag("head")) {
                    headToken = token;
                }    
                token = token.next;
            }
         
            // Depending on which tokens exist, add or update meta tags
            if (typeof(headToken)!="undefined") {
                if (typeof(titleToken)!="undefined") {
                    if (typeof(metaTitleToken)=="undefined") {
                        // No meta title yet, add from title tag
                        headToken.insertText("<meta name=\"title\" content=\"" + titleText + "\" />");      
                    }
                    else if (metaTitleToken.getAttribute("content").trim()!=titleText) {
                       // Meta title exists, but needs update
                       metaTitleToken.setAttribute("content", titleText);
                    }
                    saveme = true;
                }
                if (typeof(descriptionToken)!="undefined") {
                    if (typeof(metaDescriptionToken)=="undefined") {
                        // No meta description yet, add from descriptionToken
                        headToken.insertText("<meta name=\"description\" content=\"" + descriptionText + "\" />");
                    }
                    else if (metaDescriptionToken.getAttribute("content").trim()!=descriptionText) {
                       // Meta description exists, but needs update
                       metaDescriptionToken.setAttribute("content", descriptionText);
                    }      
                    saveme = true;
                }
            }    
            if(saveme === true) {
                tokens.save();
            }
            tokens.close();
        }
    }
}
